import { StarXpandCommand } from "star-io10-web";

export class LabelSample12_For203dpiAnd300dpi_InventoryLabel {
  static async createPrintCommands(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder().addPrinter(
        new StarXpandCommand.PrinterBuilder()
          .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleBold(true)
              .styleUnderLine(true)
              .actionPrintText("Star TSP100IV\n"),
          )
          .actionPrintText("P/N: 000001\n")
          .actionPrintBarcode(
            new StarXpandCommand.Printer.BarcodeParameter(
              "2558271100",
              StarXpandCommand.Printer.BarcodeSymbology.Code39,
            )
              .setBarDots(3)
              .setHeight(18.0)
              .setPrintHri(true),
          )
          .actionPrintText("\n" + "ABC: WAREHOUSE\n")
          .actionCut(StarXpandCommand.Printer.CutType.Partial),
      ),
    );

    return await builder.getCommands();
  }
}
